/* <nagf06.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library f06 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2153 (Feb 1998).
 * Mark 6 revised. IER-3036 (July 2000).
 */
#ifndef NAGF06
#define NAGF06

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern void f06aac(double *a, double *b, double *c, double *s);
  extern NAG_DLL_EXPIMP void NAG_CALL f06aaz_d(const char *srname, NagError *fail_f16);
  extern void f06aaz_f(const char *srname, Integer info, Integer srname_len);
  extern NAG_DLL_EXPIMP void NAG_CALL f06aaz(const char *srname, Integer info);
  extern void f06bac(double *a, double *b, double *c, double *s);
  extern void f06baf_f(double *a, double *b, double *c, double *s);
  extern NAG_DLL_EXPIMP void NAG_CALL f06bcc(double t, double *c, double *s);
  extern void f06bcf_f(double t, double *c, double *s);
  extern double f06blc(double a, double b, Boolean *failed);
  extern double f06blf_f(double a, double b, Boolean *fail);
  extern NAG_DLL_EXPIMP double NAG_CALL f06bmc(double scale, double ssq);
  extern double f06bmf_f(double scale, double ssq);
  extern NAG_DLL_EXPIMP double NAG_CALL f06bnc(double a, double b);
  extern double f06bnf_f(double a, double b);
  //cheney change Complex to complex
  /*extern void f06cac(Complex *a, Complex *b, double *c, Complex *s);
  extern void f06ccc(Complex t, double *c, Complex *s);
  extern Complex f06clc(Complex a, Complex b, Boolean *fail);*/
  extern void f06cac(complex *a, complex *b, double *c, complex *s);
  extern void f06ccc(complex &t, double *c, complex *s);
  extern complex f06clc(complex &a, complex &b, Boolean *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL f06dbc(Integer n, Integer alpha, Integer x[], Integer incx);
  extern void f06dbf_f(Integer n, Integer const_, Integer x[], Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06dfc(Integer n, Integer *x, Integer incx, Integer *y, Integer incy);
  extern void f06dff_f(Integer n, const Integer x[], Integer incx, Integer y[],
                       Integer incy);
  extern NAG_DLL_EXPIMP double NAG_CALL f06eac(Integer n, const double *x, Integer incx, const double *y, Integer incy);
  extern NAG_DLL_EXPIMP double NAG_CALL f06eaf_f(Integer n, const double x[], Integer incx, const double y[],
                         Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06ecc(Integer n, double alpha, const double *x, Integer incx, double *y,
                     Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06ecf_f(Integer n, double alpha, const double x[], Integer incx,
                       double y[], Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06edc(Integer n, double alpha, double *x, Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06edf_f(Integer n, double alpha, double x[], Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06efc(Integer n, const double *x, Integer incx, double *y, Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06eff_f(Integer n, const double x[], Integer incx, double y[],
                       Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06egc(Integer n,double *x, Integer incx, double *y, Integer incy);
  extern void f06egf_f(Integer n, double x[], Integer incx, double y[],
                       Integer incy);
  extern NAG_DLL_EXPIMP double NAG_CALL f06ejc(Integer n, const double *x, Integer incx);
  extern NAG_DLL_EXPIMP double NAG_CALL f06ejf_f(Integer n, const double x[], Integer incx);
  extern NAG_DLL_EXPIMP double NAG_CALL f06ekc(Integer n, const double *x, Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06epc(Integer n, double *x, Integer incx, double *y, Integer incy,
                     double c, double s);
  extern void f06epf_f(Integer n, double x[], Integer incx, double y[],
                       Integer incy, double c, double s);
  extern NAG_DLL_EXPIMP void NAG_CALL f06fbc(Integer n, double cnst, double *x, Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06fbf_f(Integer n, double const_, double x[], Integer incx);
  extern void f06fcc(Integer n, const double *d, Integer incd, double *x, Integer incx);
  extern void f06fcf_f(Integer n, const double d[], Integer incd, double x[],
                       Integer incx);
  extern void f06fcz(Integer n,  const double d[],  Integer incd,  double x[],
                     Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06fdc(Integer n, double alpha, double *x, Integer incx,
                     double *y, Integer incy);
  extern void f06fdf_f(Integer n, double alpha, const double x[], Integer incx,
                       double y[], Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06fgc(Integer n, double *x, Integer incx);
  extern void f06fgf_f(Integer n, double x[], Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06fjc(Integer n, const double *x, Integer incx, double *scale, double *sumsq);
  extern void f06fjf_f(Integer n, const double x[], Integer incx, double *scale,
                       double *sumsq);
  extern void f06flc(Integer n, double x[], Integer incx, double *xmax,
                     double *xmin);
  extern void f06fpc(Integer n,  double x[],  Integer incx,  double y[],
                     Integer incy,  double c, double s);
  extern void f06fqc(PivotType pivot, SequenceDirection direct, Integer n,
                     double *alpha, double *x, Integer incx, double *c, double *s);
  extern void f06fqf_f(const char *pivot, const char *direct, Integer n, double *alpha,
                       double x[], Integer incx, double c[], double s[],
                       Integer pivot_len, Integer direct_len);
  extern NAG_DLL_EXPIMP void NAG_CALL f06frc(Integer n, double *alpha, double *x, Integer incx,
                     double tol, double *zeta);
  extern void f06frf_f(Integer n, double *alpha, double x[], Integer incx,
                       double tol, double *zeta);
  extern void f06fsc(Integer n, double *alpha, double *x, Integer incx, double tol,
                     double *z1);
  extern void f06ftc(Integer n, double *delta, double *y, Integer incy,
                     double zeta, double *z, Integer incz);
  extern void f06fuc(Integer n, double *z, Integer incz, double z1, double *alpha,
                     double *x, Integer incx);
  //Cheney change Complex to complex 
  /*extern /* Double Complex */ /*int f06gaf(Complex *ret_val, Integer n, Complex *x,
                                         Integer incx, Complex *y, Integer incy);
  extern NAG_DLL_EXPIMP Complex NAG_CALL f06gbc(Integer n, Complex *x, Integer incx, Complex *y, Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06gcc(Integer n, Complex alpha, Complex *x, Integer incx, Complex *y,
                     Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06gdc(Integer n, Complex alpha, Complex *x, Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06gfc(Integer n, Complex *x, Integer incx, Complex *y, Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06ggc(Integer n, Complex *x, Integer incx, Complex *y, Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06hbc(Integer n, Complex alpha, Complex *x, Integer incx);
  extern void f06hgc(Integer n, Complex *x, Integer incx);
  extern void f06hpc(Integer n, Complex *x, Integer incx, Complex *y, Integer incy, Complex c,
                     Complex s);
  extern void f06hqc(PivotType pivot, SequenceDirection direct, Integer n, Complex *alpha,
                     Complex *x, Integer incx, double *c, Complex *s);
  extern void f06hrc(Integer n, Complex *alpha, Complex *x, Integer incx, double tol,
                     Complex *theta);
  extern NAG_DLL_EXPIMP void NAG_CALL f06jdc(Integer n, double alpha, Complex *x, Integer incx);
  extern NAG_DLL_EXPIMP double NAG_CALL f06jjc(Integer n, Complex *x, Integer incx);
  extern NAG_DLL_EXPIMP double NAG_CALL f06jkc(Integer n, Complex *x, Integer incx);*/
  extern /* Double Complex */ int f06gaf(complex *ret_val, Integer n, complex *x,
                                         Integer incx, complex *y, Integer incy);
  extern NAG_DLL_EXPIMP complex NAG_CALL f06gbc(Integer n, complex *x, Integer incx, complex *y, Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06gcc(Integer n, complex &alpha, complex *x, Integer incx, complex *y,
                     Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06gdc(Integer n, complex &alpha, complex *x, Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06gfc(Integer n, complex *x, Integer incx, complex *y, Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06ggc(Integer n, complex *x, Integer incx, complex *y, Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06hbc(Integer n, complex &alpha, complex *x, Integer incx);
  extern void f06hgc(Integer n, complex *x, Integer incx);
  extern void f06hpc(Integer n, complex *x, Integer incx, complex *y, Integer incy, complex &c,
                     complex &s);
  extern void f06hqc(PivotType pivot, SequenceDirection direct, Integer n, complex *alpha,
                     complex *x, Integer incx, double *c, complex *s);
  extern void f06hrc(Integer n, complex *alpha, complex *x, Integer incx, double tol,
                     complex *theta);
  extern NAG_DLL_EXPIMP void NAG_CALL f06jdc(Integer n, double alpha, complex *x, Integer incx);
  extern NAG_DLL_EXPIMP double NAG_CALL f06jjc(Integer n, complex *x, Integer incx);
  extern NAG_DLL_EXPIMP double NAG_CALL f06jkc(Integer n, complex *x, Integer incx);
  extern NAG_DLL_EXPIMP Integer NAG_CALL f06jlc(Integer n, double *x, Integer incx);
  extern Integer f06jlf_f(Integer n, const double x[], Integer incx);
  //Cheney change Complex to complex 
  /*extern NAG_DLL_EXPIMP Integer NAG_CALL f06jmc(Integer n, Complex *x, Integer incx);
  extern void f06kfc(Integer n, double *x, Integer incx, Complex *y, Integer incy);
  extern void f06kjc(Integer n, Complex *x, Integer incx, double *scale, double *sumsq);*/
  extern NAG_DLL_EXPIMP Integer NAG_CALL f06jmc(Integer n, complex *x, Integer incx);
  extern void f06kfc(Integer n, double *x, Integer incx, complex *y, Integer incy);
  extern void f06kjc(Integer n, complex *x, Integer incx, double *scale, double *sumsq);
  extern Integer f06klc(Integer n, double *x, Integer incx, double tol);
  extern Integer f06klf_f(Integer n, const double x[], Integer incx, double tol);
  extern NAG_DLL_EXPIMP void NAG_CALL f06pac(MatrixTranspose Trans, Integer m, Integer n, 
                                             double alpha, const double a[], Integer tda, const double x[],
                                             Integer incx, double beta, double y[], Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06paf_f(const char *trans, Integer m, Integer n, double alpha,
                       const double a[], Integer lda, const double x[], Integer incx,
                       double beta, double y[], Integer incy, Integer trans_len);
  extern NAG_DLL_EXPIMP void NAG_CALL f06pbc(MatrixTranspose trans, Integer m, Integer n, Integer kl, 
                                             Integer ku, double alpha, const double a[], Integer tda,
                                             const double x[], Integer incx, double beta, double y[], 
                                             Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06pcc(MatrixTriangle UpperLower, Integer n, double alpha, 
                                             const double a[], Integer tda, const double x[], 
                                             Integer incx, double beta, double y[], Integer incy);
  extern void f06pcf_f(const char *uplo, Integer n, double alpha, const double a[],
                       Integer lda, const double x[], Integer incx, double beta,
                       double y[], Integer incy, Integer uplo_len);
  extern void f06pcf(const char *uplo, Integer n, double alpha, double a[],
                     Integer lda, double x[], Integer incx, double beta,
                     double y[], Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06pdc(MatrixTriangle uplo, Integer n, Integer k, double alpha, 
                                             const double a[], Integer tda, const double x[], Integer incx,
                                             double beta, double y[], Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06pec(MatrixTriangle UpperLower, Integer n, double alpha, 
                                             const double ap[], const double x[], Integer incx, 
                                             double beta, double y[], Integer incy);
  extern void f06pef(MatrixTriangle UpperLower, Integer n, double alpha, double *ap,
                     double *x, Integer incx, 
                     double beta, double *y, Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06pfc(MatrixTriangle UpperLower, MatrixTranspose Trans, 
                                             MatrixUnitTriangular TriangularMatrix, Integer n,
                                             const double a[], Integer tda, double x[], Integer incx);
  extern void f06pff_f(const char *uplo, const char *trans, const char *diag, Integer n,
                       const double a[], Integer lda, double x[], Integer incx,
                       Integer uplo_len, Integer trans_len, Integer diag_len);
  extern NAG_DLL_EXPIMP void NAG_CALL f06pgc(MatrixTriangle uplo, MatrixTranspose trans, 
                                             MatrixUnitTriangular diag, Integer n, Integer k, 
                                             const double a[], Integer tda, double x[], Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06phc(MatrixTriangle UpperLower, MatrixTranspose Trans,
                                             MatrixUnitTriangular Diag, Integer n, const double ap[], 
                                             double x[], Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06phf_f(const char *uplo, const char *trans, const char *diag, Integer n,
                       const double ap[], double x[], Integer incx, Integer uplo_len,
                       Integer trans_len, Integer diag_len);
  extern NAG_DLL_EXPIMP void NAG_CALL f06phf(MatrixTriangle UpperLower, MatrixTranspose Trans,
                     MatrixUnitTriangular Diag, Integer n, double *ap, double *x,
                     Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06pjc(MatrixTriangle UpperLower, MatrixTranspose Trans, 
                                             MatrixUnitTriangular TriangularMatrix, Integer n, const double a[],
                                             Integer tda, double x[], Integer incx);
  extern void f06pjf_f(const char *uplo, const char *trans, const char *diag, Integer n,
                       const double a[], Integer lda, double x[], Integer incx,
                       Integer uplo_len, Integer trans_len, Integer diag_len);
  extern NAG_DLL_EXPIMP void NAG_CALL f06pkc(MatrixTriangle uplo, MatrixTranspose trans,
                                             MatrixUnitTriangular diag, Integer n, Integer k,
                                             const double a[], Integer tda, double x[], Integer incx);
  extern void f06pkf(MatrixTriangle uplo, MatrixTranspose trans,
                     MatrixUnitTriangular diag, Integer n, Integer k,
                     double *a, Integer lda, double *x, Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06plc(MatrixTriangle UpperLower, MatrixTranspose Trans,
                                             MatrixUnitTriangular Diag, Integer n, const double ap[], 
                                             double x[], Integer incx);
  extern void f06plf_f(const char *uplo, const char *trans, const char *diag, Integer n,
                       const double ap[], double x[], Integer incx, Integer uplo_len,
                       Integer trans_len, Integer diag_len);
  extern void f06plf(MatrixTriangle UpperLower, MatrixTranspose Trans,
                     MatrixUnitTriangular Diag, Integer n, double *ap, double *x,
                     Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06pmc(Integer m, Integer n, double alpha, const double x[],
                                             Integer incx, const double y[], Integer incy, 
                                             double a[], Integer tda);
  extern void f06pmf_f(Integer m, Integer n, double alpha, const double x[],
                       Integer incx, const double y[], Integer incy, double a[],
                       Integer lda);
  extern NAG_DLL_EXPIMP void NAG_CALL f06ppc(MatrixTriangle uplo, Integer n, double alpha, const double x[],
                                             Integer incx, double a[], Integer tda);
  extern NAG_DLL_EXPIMP void NAG_CALL f06pqc(MatrixTriangle uplo, Integer n, double alpha,
                                             const double x[], Integer incx, double ap[]);
  extern void f06pqf_f(const char *uplo, Integer n, double alpha, const double x[],
                       Integer incx, double ap[], Integer uplo_len);
  extern void f06pqf(MatrixTriangle uplo, Integer n, double alpha,
                     double x[], Integer incx, double ap[]);
  extern NAG_DLL_EXPIMP void NAG_CALL f06prc(MatrixTriangle UpperLower, Integer n, double alpha, 
                                             const double x[], Integer incx, const double y[], Integer incy,
                                             double a[], Integer tda);
  extern void f06prf_f(const char *uplo, Integer n, double alpha, const double x[],
                       Integer incx, const double y[], Integer incy, double a[],
                       Integer lda, Integer uplo_len);
  extern void f06prf(const char *uplo, Integer n, double alpha, double x[],
                     Integer incx, double y[], Integer incy, double a[],
                     Integer lda);
  extern NAG_DLL_EXPIMP void NAG_CALL f06psc(MatrixTriangle UpperLower, Integer n, double alpha, 
                                             const double x[], Integer incx, const double y[], 
                                             Integer incy, double ap[]);
  extern void f06psf(MatrixTriangle UpperLower, Integer n,  double alpha, double x[],
                     Integer incx,  double y[],  Integer incy,
                     double ap[]);
  //Cheney change matrix to mat 2006-6-5
  /*extern NAG_DLL_EXPIMP void NAG_CALL f06qfc(MatrixType matrix, Integer m, Integer n, const double *a, Integer tda,
                     double *b, Integer tdb);*/
  extern NAG_DLL_EXPIMP void NAG_CALL f06qfc(MatrixType mat, Integer m, Integer n, const double *a, Integer tda,
                     double *b, Integer tdb);
  //Cheney change matrix to mat  2006-6-5
   /*extern NAG_DLL_EXPIMP void NAG_CALL f06qff_f(const char *matrix, Integer m, Integer n, const double a[],
                                               Integer lda, double b[], Integer ldb,
                                               Integer matrix_len);*/
  extern NAG_DLL_EXPIMP void NAG_CALL f06qff_f(const char *mat, Integer m, Integer n, const double a[],
                                               Integer lda, double b[], Integer ldb,
                                               Integer matrix_len);
  extern NAG_DLL_EXPIMP double NAG_CALL f06qgc(NormType norm, MatrixType mat, Integer m, Integer n,
                       double *a, Integer tda);
  //Cheney change matrix to mat 2006-6-5
  /* extern NAG_DLL_EXPIMP void NAG_CALL f06qhc(MatrixType matrix, Integer m, Integer n, double constant,
                     double diag, double *a, Integer tda);*/
  extern NAG_DLL_EXPIMP void NAG_CALL f06qhc(MatrixType mat, Integer m, Integer n, double constant,
                     double diag, double *a, Integer tda);
  //Cheney change matrix to mat 2006-6-5
  /*extern void f06qhf_f(const char *matrix, Integer m, Integer n, double const_,
                       double diag, double a[], Integer lda, Integer matrix_len);*/
  extern void f06qhf_f(const char *mat, Integer m, Integer n, double const_,
                       double diag, double a[], Integer lda, Integer matrix_len);
  extern void f06qjc(OperationSide side, MatrixTranspose trans, Integer n, Integer *perm, Integer k,
                     double *b, Integer ldb);
  extern void f06qkc(OperationSide Side, MatrixTranspose Trans, Integer n, 
                     double *perm, Integer k, double *b, Integer tdb);
  extern void f06qkf(OperationSide side, MatrixTranspose trans, Integer n,
                     double perm[], Integer k,  double b[],  Integer ldb);
  extern void f06qkf_f(const char *side, const char *trans, Integer n, const double perm[],
                       Integer k, double b[], Integer ldb, Integer side_len,
                       Integer trans_len);
  extern void f06qnc(OperationSide side, Integer n, Integer k1, Integer k2,
                     double s[], double a[], Integer tda);
  extern void f06qnz(const char *side,  Integer n, Integer k1, Integer k2,
                     double s[], double a[],  Integer lda);
  extern void f06qqc(Integer n, double alpha, double *x, Integer incx,
                     double *a, Integer tda, double *c, double *s);
  extern void f06qrc(OperationSide side, Integer n, Integer k1, Integer k2, double *c,
                     double *s, double *a, Integer tda);
  extern void f06qsc(OperationSide side,  Integer n, Integer k1, Integer k2,
                     double c[], double s[], double a[],  Integer tda);
  extern void f06qtc(OperationSide side, Integer n, Integer k1, Integer k2, double *c,
                     double *s, double *a, Integer tda);
  extern void f06qtf_f(const char *side, Integer n, Integer k1, Integer k2,
                       double c[], double s[], double a[], Integer lda,
                       Integer side_len);
  extern void f06qvc(OperationSide side, Integer n, Integer k1, Integer k2,
                     double c[], double s[], double a[], Integer tda);
  extern void f06qwc(OperationSide side,  Integer n, Integer k1, Integer k2,
                     double c[], double s[], double a[], Integer lda);
  extern void f06qxc(OperationSide side, PivotType pivot, SequenceDirection direct,
                     Integer m, Integer  n, Integer k1, Integer k2, double *c,
                     double *s, double *a, Integer tda);
  extern void f06qxf_f(const char *side, const char *pivot, const char *direct, Integer m,
                       Integer n, Integer k1, Integer k2, const double c[],
                       const double s[], double a[], Integer lda, Integer side_len,
                       Integer pivot_len, Integer direct_len);
  extern void f06qxf(OperationSide side, PivotType pivot, SequenceDirection direct,
                     Integer m, Integer n, Integer k1, Integer k2, double c[],
                     double s[], double a[], Integer lda);
  extern void f06qzz(const char *hess,  Integer n, Integer k1, Integer k2,
                     double c[], double s[], double a[],  Integer tda);
  extern NAG_DLL_EXPIMP double NAG_CALL f06rac(NormType norm,  Integer m, Integer n,  double a[],
                       Integer tda,  double work[]);
  extern double f06raf_f(const char *norm, Integer m, Integer n, const double a[],
Integer lda, double work[], Integer norm_len);
  extern double f06rcf_f(const char *norm, const char *uplo, Integer n, const double a[],
                         Integer lda, double work[], Integer norm_len, Integer uplo_len);
  extern double f06rcf(const char *norm, const char *uplo, Integer n, double a[],
                       Integer lda, double work[]);
  extern double f06rjc(const char *norm, const char *uplo, const char *diag,  Integer m, Integer n,
                       double a[],  Integer tda,  double work[]);
  extern double f06rmf(const char *norm, Integer n, double a[], Integer lda,
                       double work[]);
  extern double f06rmf_f(const char *norm, Integer n, const double a[], Integer lda,
double work[], Integer norm_len);
	//Cheney change Complex to complex
  /*extern NAG_DLL_EXPIMP void NAG_CALL f06sac(MatrixTranspose Trans, Integer m, Integer n, 
                                             Complex alpha, const Complex a[], Integer tda, const Complex x[],
                                             Integer incx, Complex beta, Complex y[], Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06sbc(MatrixTranspose trans, Integer m, Integer n, Integer kl, 
                                             Integer ku, Complex alpha, const Complex a[], Integer tda,
                                             const Complex x[], Integer incx, Complex beta, 
                                             Complex y[], Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06scc(MatrixTriangle UpperLower, Integer n, Complex alpha,
                                             const Complex a[], Integer tda, const Complex x[], 
                                             Integer incx, Complex beta, Complex y[], Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06sdc(MatrixTriangle uplo, Integer n, Integer k, Complex alpha, 
                                             const Complex a[], Integer tda, const Complex x[], Integer incx, 
                                             Complex beta, Complex y[], Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06sec(MatrixTriangle UpperLower, Integer n, Complex alpha, 
                                             const Complex ap[], const Complex x[], Integer incx, 
                                             Complex beta, Complex y[], Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06sfc(MatrixTriangle UpperLower, MatrixTranspose Trans, 
                                             MatrixUnitTriangular TriangularMatrix, Integer n, 
                                             const Complex a[], Integer tda, Complex x[], Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06sgc(MatrixTriangle uplo, MatrixTranspose trans, 
                                             MatrixUnitTriangular diag, Integer n, Integer k, 
                                             const Complex a[], Integer tda, Complex x[], Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06shc(MatrixTriangle UpperLower, MatrixTranspose Trans,
                                             MatrixUnitTriangular Diag, Integer n, const Complex ap[],
                                             Complex x[], Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06sjc(MatrixTriangle UpperLower, MatrixTranspose Trans, 
                                             MatrixUnitTriangular TriangularMatrix, Integer n, 
                                             const Complex a[], Integer tda, Complex x[], Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06skc(MatrixTriangle uplo, MatrixTranspose trans,
                                             MatrixUnitTriangular diag, Integer n, Integer k,
                                             const Complex a[], Integer tda, Complex x[], Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06slc(MatrixTriangle UpperLower, MatrixTranspose Trans,
                                             MatrixUnitTriangular Diag, Integer n, const Complex ap[],
                                             Complex x[], Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06smc(Integer m, Integer n, Complex alpha, const Complex x[], 
                                             Integer incx, const Complex y[], Integer incy, 
                                             Complex a[], Integer tda);
  extern NAG_DLL_EXPIMP void NAG_CALL f06snc(Integer m, Integer n, Complex alpha, const Complex x[], 
                                             Integer incx, const Complex y[], Integer incy, Complex a[],
                                             Integer tda);
  extern NAG_DLL_EXPIMP void NAG_CALL f06spc(MatrixTriangle uplo, Integer n, double alpha, 
                                             const Complex x[], Integer incx, Complex a[], Integer tda);
  extern NAG_DLL_EXPIMP void NAG_CALL f06sqc(MatrixTriangle uplo, Integer n, double alpha,
                                             const Complex x[], Integer incx, Complex ap[]);
  extern NAG_DLL_EXPIMP void NAG_CALL f06src(MatrixTriangle UpperLower, Integer n, Complex alpha, 
                                             const Complex x[], Integer incx, const Complex y[],
                                             Integer incy, Complex a[], Integer tda);
  extern NAG_DLL_EXPIMP void NAG_CALL f06ssc(MatrixTriangle UpperLower, Integer n, Complex alpha, 
                                             const Complex x[], Integer incx, const Complex y[], 
                                             Integer incy, Complex ap[]);*/
   extern NAG_DLL_EXPIMP void NAG_CALL f06sac(MatrixTranspose Trans, Integer m, Integer n, 
                                             complex &alpha, const complex a[], Integer tda, const complex x[],
                                             Integer incx, complex &beta, complex y[], Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06sbc(MatrixTranspose trans, Integer m, Integer n, Integer kl, 
                                             Integer ku, complex &alpha, const complex a[], Integer tda,
                                             const complex x[], Integer incx, complex &beta, 
                                             complex y[], Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06scc(MatrixTriangle UpperLower, Integer n, complex &alpha,
                                             const complex a[], Integer tda, const complex x[], 
                                             Integer incx, complex &beta, complex y[], Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06sdc(MatrixTriangle uplo, Integer n, Integer k, complex &alpha, 
                                             const complex a[], Integer tda, const complex x[], Integer incx, 
                                             complex beta, complex y[], Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06sec(MatrixTriangle UpperLower, Integer n, complex &alpha, 
                                             const complex ap[], const complex x[], Integer incx, 
                                             complex beta, complex y[], Integer incy);
  extern NAG_DLL_EXPIMP void NAG_CALL f06sfc(MatrixTriangle UpperLower, MatrixTranspose Trans, 
                                             MatrixUnitTriangular TriangularMatrix, Integer n, 
                                             const complex a[], Integer tda, complex x[], Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06sgc(MatrixTriangle uplo, MatrixTranspose trans, 
                                             MatrixUnitTriangular diag, Integer n, Integer k, 
                                             const complex a[], Integer tda, complex x[], Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06shc(MatrixTriangle UpperLower, MatrixTranspose Trans,
                                             MatrixUnitTriangular Diag, Integer n, const complex ap[],
                                             complex x[], Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06sjc(MatrixTriangle UpperLower, MatrixTranspose Trans, 
                                             MatrixUnitTriangular TriangularMatrix, Integer n, 
                                             const complex a[], Integer tda, complex x[], Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06skc(MatrixTriangle uplo, MatrixTranspose trans,
                                             MatrixUnitTriangular diag, Integer n, Integer k,
                                             const complex a[], Integer tda, complex x[], Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06slc(MatrixTriangle UpperLower, MatrixTranspose Trans,
                                             MatrixUnitTriangular Diag, Integer n, const complex ap[],
                                             complex x[], Integer incx);
  extern NAG_DLL_EXPIMP void NAG_CALL f06smc(Integer m, Integer n, complex &alpha, const complex x[], 
                                             Integer incx, const complex y[], Integer incy, 
                                             complex a[], Integer tda);
  extern NAG_DLL_EXPIMP void NAG_CALL f06snc(Integer m, Integer n, complex &alpha, const complex x[], 
                                             Integer incx, const complex y[], Integer incy, complex a[],
                                             Integer tda);
  extern NAG_DLL_EXPIMP void NAG_CALL f06spc(MatrixTriangle uplo, Integer n, double alpha, 
                                             const complex x[], Integer incx, complex a[], Integer tda);
  extern NAG_DLL_EXPIMP void NAG_CALL f06sqc(MatrixTriangle uplo, Integer n, double alpha,
                                             const complex x[], Integer incx, complex ap[]);
  extern NAG_DLL_EXPIMP void NAG_CALL f06src(MatrixTriangle UpperLower, Integer n, complex &alpha, 
                                             const complex x[], Integer incx, const complex y[],
                                             Integer incy, complex a[], Integer tda);
  extern NAG_DLL_EXPIMP void NAG_CALL f06ssc(MatrixTriangle UpperLower, Integer n, complex &alpha, 
                                             const complex x[], Integer incx, const complex y[], 
                                             Integer incy, complex ap[]);
  //Cheney change matrix to mat and Complex to complex 2006-6-5
  /*extern NAG_DLL_EXPIMP void NAG_CALL f06tfc(MatrixType matrix, Integer m, Integer n,
                                             const Complex *a, Integer tda,
                                             Complex *b, Integer tdb);
  extern NAG_DLL_EXPIMP void NAG_CALL f06thc(MatrixType matrix, Integer m, Integer n, Complex constant, 
                     Complex diag, Complex *a, Integer tda);*/
   extern NAG_DLL_EXPIMP void NAG_CALL f06tfc(MatrixType mat, Integer m, Integer n,
                                             const complex *a, Integer tda,
                                             complex *b, Integer tdb);
  extern NAG_DLL_EXPIMP void NAG_CALL f06thc(MatrixType mat, Integer m, Integer n, complex constant, 
                     complex &diag, complex *a, Integer tda);
  //Cheney change Complex to complex 2006-6-6
  /*extern void f06ttc(OperationSide side, Integer n, Integer k1, Integer k2, double *c,
                     Complex *s, Complex *a, Integer tda);
  extern void f06txc(OperationSide side, PivotType pivot, SequenceDirection direct,
                     Integer m, Integer n, Integer k1, Integer k2, double *c,
                     Complex *s, Complex *a, Integer tda);
  extern NAG_DLL_EXPIMP double NAG_CALL f06uaf(const char *norm, Integer m, Integer n, Complex *a,
                       Integer lda, double *work);
  extern double f06umf(const char *norm, Integer n, Complex *a, Integer lda,
                       double *work);*/
  extern void f06ttc(OperationSide side, Integer n, Integer k1, Integer k2, double *c,
                     complex *s, complex *a, Integer tda);
  extern void f06txc(OperationSide side, PivotType pivot, SequenceDirection direct,
                     Integer m, Integer n, Integer k1, Integer k2, double *c,
                     complex *s, complex *a, Integer tda);
  extern NAG_DLL_EXPIMP double NAG_CALL f06uaf(const char *norm, Integer m, Integer n, complex *a,
                       Integer lda, double *work);
  extern double f06umf(const char *norm, Integer n, complex *a, Integer lda,
                       double *work);
  //Cheney change matrix to mat and Complex to complex 2006-6-5
  /*extern NAG_DLL_EXPIMP double NAG_CALL f06vgc(NormType norm, MatrixType mat, Integer m, Integer n, 
                       Complex *a, Integer tda);*/
  extern NAG_DLL_EXPIMP double NAG_CALL f06vgc(NormType norm, MatrixType mat, Integer m, Integer n, 
                       complex *a, Integer tda);
  //Cheney change Complex to complex 2006-6-6
  /*extern void f06vkc(OperationSide side, MatrixTranspose trans, Integer n, double *perm,
                     Integer k, Complex *b, Integer tdb);
  extern void f06vxc(OperationSide side, PivotType pivot, SequenceDirection direct,
                     Integer m, Integer n, Integer k1, Integer k2, double *c, double *s,
                     Complex *a, Integer tda);*/
  extern void f06vkc(OperationSide side, MatrixTranspose trans, Integer n, double *perm,
                     Integer k, complex *b, Integer tdb);
  extern void f06vxc(OperationSide side, PivotType pivot, SequenceDirection direct,
                     Integer m, Integer n, Integer k1, Integer k2, double *c, double *s,
                     complex *a, Integer tda);
  extern NAG_DLL_EXPIMP void NAG_CALL f06yac(MatrixTranspose transa, MatrixTranspose transb,
                                             Integer m, Integer n,
                                             Integer k, double alpha, const double a[], Integer tda,
                                             const double b[], Integer tdb, double beta,
                                             double c[], Integer tdc);
  extern void f06yaf_f(const char *transa, const char *transb, Integer m, Integer n,
                       Integer k, double alpha, const double a[], Integer lda,
                       const double b[], Integer ldb, double beta, double c[],
                       Integer ldc, Integer transa_len, Integer transb_len);
  extern void f06yaf(const char *transa, const char *transb, Integer m, Integer n, Integer k, 
                     double alpha, double *a, Integer lda, double *b,
                     Integer ldb, double beta, double *c, Integer ldc);
  extern NAG_DLL_EXPIMP void NAG_CALL f06ycc(OperationSide side, MatrixTriangle uplo, Integer m, Integer n,
                                             double alpha, const double a[], Integer tda, const double b[],
                                             Integer tdb, double beta, double c[], Integer tdc);
  extern NAG_DLL_EXPIMP void NAG_CALL f06yfc(OperationSide side, MatrixTriangle uplo, MatrixTranspose transa,
                                             MatrixUnitTriangular diag, Integer m, Integer n, double alpha, 
                                             const double a[], Integer tda, double b[], Integer tdb);
  extern void f06yff_f(const char *side, const char *uplo, const char *transa, const char *diag,
                       Integer m, Integer n, double alpha, const double a[],
                       Integer lda, double b[], Integer ldb, Integer side_len,
                       Integer uplo_len, Integer transa_len, Integer diag_len);
  extern NAG_DLL_EXPIMP void NAG_CALL f06yjc(OperationSide side, MatrixTriangle uplo, MatrixTranspose transa,
                                             MatrixUnitTriangular diag, Integer m, Integer n, double alpha, 
                                             const double a[], Integer tda, double b[], Integer tdb);
  extern void f06yjf_f(const char *side, const char *uplo, const char *transa, const char *diag,
                       Integer m, Integer n, double alpha, const double a[],
                       Integer lda, double b[], Integer ldb, Integer side_len,
                       Integer uplo_len, Integer transa_len, Integer diag_len);
  extern void f06yjf(const char *side, const char *uplo, const char *transa, const char *diag, Integer m,
                     Integer n, double alpha, double *a, 
                     Integer lda, double *b, Integer ldb);
  extern NAG_DLL_EXPIMP void NAG_CALL f06ypc(MatrixTriangle uplo, MatrixTranspose trans, Integer n, Integer k,
                                             double alpha, const double a[], Integer tda,
                                             double beta, double c[], Integer tdc);
  extern void f06ypf_f(const char *uplo, const char *trans, Integer n, Integer k,
                       double alpha, const double a[], Integer lda, double beta,
                       double c[], Integer ldc, Integer uplo_len, Integer trans_len);
  extern NAG_DLL_EXPIMP void NAG_CALL f06yrc(MatrixTriangle uplo, MatrixTranspose trans, Integer n, Integer k,
                                             double alpha, const double a[], Integer tda, const double b[],
                                             Integer tdb, double beta, double c[], Integer tdc);
  extern void f06yrf_f(const char *uplo, const char *trans, Integer n, Integer k,
                       double alpha, const double a[], Integer lda, const double b[],
                       Integer ldb, double beta, double c[], Integer ldc,
                       Integer uplo_len, Integer trans_len);
  //Cheney change Complex to complex 2006-6-6
  /*extern NAG_DLL_EXPIMP void NAG_CALL f06zac(MatrixTranspose transa, MatrixTranspose transb,
                                             Integer m, Integer n,
                                             Integer k, Complex alpha, const Complex a[], Integer tda,
                                             const Complex b[], Integer tdb, Complex beta,
                                             Complex c[], Integer tdc);
  extern NAG_DLL_EXPIMP void NAG_CALL f06zcc(OperationSide side, MatrixTriangle uplo, Integer m, Integer n,
                                             Complex alpha, const Complex a[], Integer tda, const Complex b[],
                                             Integer tdb, Complex beta, Complex c[], Integer tdc);
  extern NAG_DLL_EXPIMP void NAG_CALL f06zfc(OperationSide side, MatrixTriangle uplo, MatrixTranspose transa,
                                             MatrixUnitTriangular diag, Integer m, Integer n, Complex alpha, 
                                             const Complex a[], Integer tda, Complex b[], Integer tdb);
  extern NAG_DLL_EXPIMP void NAG_CALL f06zjc(OperationSide side, MatrixTriangle uplo, MatrixTranspose transa,
                                             MatrixUnitTriangular diag, Integer m, Integer n, Complex alpha, 
                                             const Complex a[], Integer tda, Complex b[], Integer tdb);
  extern NAG_DLL_EXPIMP void NAG_CALL f06zpc(MatrixTriangle uplo, MatrixTranspose trans, Integer n, Integer k,
                                             double alpha, const Complex a[], Integer tda,
                                             double beta, Complex c[], Integer tdc);
  extern NAG_DLL_EXPIMP void NAG_CALL f06zrc(MatrixTriangle uplo, MatrixTranspose trans, Integer n, Integer k,
                                             Complex alpha, const Complex a[], Integer tda, 
                                             const Complex b[], Integer tdb, double beta, Complex c[], 
                                             Integer tdc);
  extern NAG_DLL_EXPIMP void NAG_CALL f06ztc(OperationSide side, MatrixTriangle uplo, Integer m, Integer n,
                                             Complex alpha, const Complex a[], Integer tda, const Complex b[],
                                             Integer tdb, Complex beta, Complex c[], Integer tdc);
  extern NAG_DLL_EXPIMP void NAG_CALL f06zuc(MatrixTriangle uplo, MatrixTranspose trans, Integer n, Integer k,
                                             Complex alpha, const Complex a[], Integer tda,
                                             Complex beta, Complex c[], Integer tdc);
  extern NAG_DLL_EXPIMP void NAG_CALL f06zwc(MatrixTriangle uplo, MatrixTranspose trans, Integer n, Integer k,
                                             Complex alpha, const Complex a[], Integer tda, 
                                             const Complex b[], Integer tdb, Complex beta, Complex c[], 
                                             Integer tdc);*/
  extern NAG_DLL_EXPIMP void NAG_CALL f06zac(MatrixTranspose transa, MatrixTranspose transb,
                                             Integer m, Integer n,
                                             Integer k, complex &alpha, const complex a[], Integer tda,
                                             const complex b[], Integer tdb, complex &beta,
                                             complex c[], Integer tdc);
  extern NAG_DLL_EXPIMP void NAG_CALL f06zcc(OperationSide side, MatrixTriangle uplo, Integer m, Integer n,
                                             complex &alpha, const complex a[], Integer tda, const complex b[],
                                             Integer tdb, complex &beta, complex c[], Integer tdc);
  extern NAG_DLL_EXPIMP void NAG_CALL f06zfc(OperationSide side, MatrixTriangle uplo, MatrixTranspose transa,
                                             MatrixUnitTriangular diag, Integer m, Integer n, complex &alpha, 
                                             const complex a[], Integer tda, complex b[], Integer tdb);
  extern NAG_DLL_EXPIMP void NAG_CALL f06zjc(OperationSide side, MatrixTriangle uplo, MatrixTranspose transa,
                                             MatrixUnitTriangular diag, Integer m, Integer n, complex &alpha, 
                                             const complex a[], Integer tda, complex b[], Integer tdb);
  extern NAG_DLL_EXPIMP void NAG_CALL f06zpc(MatrixTriangle uplo, MatrixTranspose trans, Integer n, Integer k,
                                             double &alpha, const complex a[], Integer tda,
                                             double &beta, complex c[], Integer tdc);
  extern NAG_DLL_EXPIMP void NAG_CALL f06zrc(MatrixTriangle uplo, MatrixTranspose trans, Integer n, Integer k,
                                             complex &alpha, const complex a[], Integer tda, 
                                             const complex b[], Integer tdb, double beta, complex c[], 
                                             Integer tdc);
  extern NAG_DLL_EXPIMP void NAG_CALL f06ztc(OperationSide side, MatrixTriangle uplo, Integer m, Integer n,
                                             complex &alpha, const complex a[], Integer tda, const complex b[],
                                             Integer tdb, complex &beta, complex c[], Integer tdc);
  extern NAG_DLL_EXPIMP void NAG_CALL f06zuc(MatrixTriangle uplo, MatrixTranspose trans, Integer n, Integer k,
                                             complex &alpha, const complex a[], Integer tda,
                                             complex &beta, complex c[], Integer tdc);
  extern NAG_DLL_EXPIMP void NAG_CALL f06zwc(MatrixTriangle uplo, MatrixTranspose trans, Integer n, Integer k,
                                             complex &alpha, const complex a[], Integer tda, 
                                             const complex b[], Integer tdb, complex &beta, complex c[], 
                                             Integer tdc);
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGF06 */
